/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT			*
 *	CPY 5/28/10 ORG-74-P1 CCW_CW_BUTTON_NOT_SHOWING_SWITCH_WHEN_CLICKED			*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////
#include "DialogEx.h"


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.

#define SWITCH_LAYER "layer -c; \n ;{page -T %s; layer -i;layer -i %%Z; queue {layer -a};}"
#define POLAR_FUN   "PolarFun"
#define CART_FUN	"Function"

#define PARAM_POLAR				"Polar"
#define PARAM_FUNTION			"Function"
#define PARAM_POLARFUNCTION		"PolarFuction"

#define MAX_FUNCTION_CONTROLS  6
static int nIDFunction[]= {IDC_NEW_FUNCTION, IDC_POLAR_RESCALE, IDC_POLAR_SWITCH, IDC_POLAR_RENAME, 0};
static int nIDPolar[] = {IDC_POLAR_ANGULAR_RANGE, IDC_POLAR_CLOCK_WISE1, IDC_POLAR_COUNTER_CLOCK_WISE1, 0};;
static int nIDRadius[] = {IDC_POLAR_RADIUS, IDC_POLAR_RADIUS_0, IDC_POLAR_RADIUS_Y, 0};;

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

/// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
#define TAG_CW 	 "Clockwise"  
#define TAG_PR 	 "PolaRadius" 
//#define ENABLESHOWBASE  2
static int nIDSwichLayer[] = {IDC_POLAR_ANGULAR_RANGE, IDC_POLAR_CLOCK_WISE1, IDC_POLAR_COUNTER_CLOCK_WISE1, IDC_POLAR_RADIUS_0, IDC_POLAR_RADIUS_Y, 0};
static int nIDSwichLayerFunc[] = {IDC_POLAR_ANGULAR_RANGE, IDC_POLAR_CLOCK_WISE1, IDC_POLAR_COUNTER_CLOCK_WISE1, 0};

/// end POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
class OC_REGISTERED GraphPolarBar : public Dialog
{
public:
	GraphPolarBar()
	:Dialog(IDD_POLAR_CONTROL, "Odlg8")
	{
		m_bPolar = FALSE;
		m_nOffset = 0;
		m_bFuncKind = FALSE;	/// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
	}

	// Called by internal
	BOOL GetSettings(TreeNode &trSplitterPane, Page &page)
	{
		return TRUE;
	}
	// Called by internal
	BOOL SetSettings(TreeNode &trSplitterPane, Page &page)
	{
		m_page = page;
		return TRUE;
	}
	/// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
	enum
	{
		ENABLESHOW_HIDE = -2,
		ENABLESHOW_SHOW = -1,
		ENABLESHOW_BASE = 2
		
	};
	//---- CPY 5/28/10 ORG-74-P1 CCW_CW_BUTTON_NOT_SHOWING_SWITCH_WHEN_CLICKED
private:
	void update_CW_CCW_buttons()
	{
		int nRadar = 0, nFree = 0;
		GetPolarRadarAndFreeSettings(nRadar, nFree);
		m_brbCW.PressedDown = nRadar;
		m_brbCCW.PressedDown = !nRadar;
	}
public:
	//----
	void UpdateRadio()
	{
		if(!m_bPolar)
			return;
		int nRadar = 0, nFree = 0;
		GetPolarRadarAndFreeSettings(nRadar, nFree);

		if(nRadar >=0 && nFree >= 0)
		{
			m_brbCW.PressedDown = nRadar;
			m_brbCCW.PressedDown = !nRadar;

			if(!m_bFuncKind)
			{
				Button btn = GetItem(nFree ? IDC_POLAR_RADIUS_Y : IDC_POLAR_RADIUS_0);
				btn.Check = true;
			}
		}
		int *pnCtrls = m_bFuncKind ? nIDSwichLayerFunc : nIDSwichLayer;
		Show(pnCtrls, (nRadar <0) ? ENABLESHOW_HIDE : ENABLESHOW_SHOW);
	}
	
	BOOL GetPolarRadarAndFreeSettings(int &nRadar, int &nFree)
	{
		nRadar = nFree = 0;
		if(!m_bPolar)
			return FALSE;
		if(!m_page)
		{
			ASSERT(FALSE);
			return FALSE;
		}
		GraphLayer gl = m_page.Layers();
		if(!gl)
		{
			ASSERT(FALSE);
			return FALSE;
		}
		
		DWORD dwLayerCoordinateMoreinfo = 0;
		UINT nCoordinateType = gl.GetCoordinateType(&dwLayerCoordinateMoreinfo);
		if(FRAME_COOR_POLAR != nCoordinateType)
		{
			nRadar = nFree = -1;
			return FALSE;
		}
		
		nRadar = (dwLayerCoordinateMoreinfo & FRAME_COOR_POLAR_RADAR) ? 1 : 0;
		nFree = (dwLayerCoordinateMoreinfo & FRAME_COOR_POLAR_FREE) ? 1 : 0;
		return TRUE;
	}
	
	BOOL OnActiveLayerChange()
	{
		Page wp=Project.Pages();
		if ( !wp  || !m_page || (wp.GetName() != m_page.GetName()))
			return FALSE;
		
		UpdateRadio();

		return TRUE;
	}
	void  SetStateFromPage()
	{
		if(!m_page)
			return;
		BOOL bHasFunction = m_page.GetNextFunctionPlotIndex();
		BOOL bHasPolarPlot = FALSE;
		foreach (GraphLayer gl in m_page.Layers)
		{
			if(FRAME_COOR_POLAR & gl.GetCoordinateType())
			{
				bHasPolarPlot = TRUE;
				break;
			}
		}
		string strParam =PARAM_POLAR; //this is default
		if(bHasFunction)
		{
			strParam = (bHasPolarPlot ?  PARAM_POLARFUNCTION : PARAM_FUNTION);
		}
		m_page.Info.System.DialogBar.Parameter$=strParam;
		SetState(strParam); 

	}
	/// end POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT


	EVENTS_BEGIN
		ON_INIT(OnInitDialog) 
		ON_BN_CLICKED(IDC_POLAR_ANGULAR_RANGE, OnModifyAngularRange)
		ON_BN_CLICKED(IDC_POLAR_CLOCK_WISE1, SetOrientClockwise)
		ON_BN_CLICKED(IDC_POLAR_COUNTER_CLOCK_WISE1, SetOrientCounterClockwise)
		ON_BN_CLICKED(IDC_POLAR_RADIUS_0, SetRadiusFromZero)
		ON_BN_CLICKED(IDC_POLAR_RADIUS_Y, SetRadiusFromYAxis)

		ON_BN_CLICKED(IDC_NEW_FUNCTION, OnNewFunction)
		ON_BN_CLICKED(IDC_POLAR_RESCALE, OnRescale)
		ON_BN_CLICKED(IDC_POLAR_SWITCH, OnSwitchToPolar)
		ON_BN_CLICKED(IDC_POLAR_RENAME, OnRename)
		ON_CHANGE_LAYER(OnActiveLayerChange)   /// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT

	EVENTS_END
	
	BOOL OnInitDialog()
	{
		m_brbCW = GetItem(IDC_POLAR_CLOCK_WISE1);
		m_brbCCW = GetItem(IDC_POLAR_COUNTER_CLOCK_WISE1);
		vector<string>  vstrCW;
		vector<string>  vstrCCW;
		vstrCW.SetSize(1);
		vstrCCW.SetSize(1);
		vstrCW[0] = _L("Clockwise");
		vstrCCW[0] = _L("Counter Clockwise");
		
		/// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
		//m_brbCW.Init(1, IDB_POLAR_ORIENT, 48, vstrCW, 1);
		m_brbCW.Init(1, IDB_POLAR_ORIENT, 48, vstrCW, 2);
		/// end POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
		m_brbCW.Check = false;
		m_brbCCW.Init(1, IDB_POLAR_ORIENT, 48, vstrCCW);
		m_brbCCW.Check = false;
		if(!m_page)
		{
			m_page = Project.Pages();
			if(!m_page)
				return FALSE;
		}
		
		string strParam = m_page.Info.System.DialogBar.Parameter$;
		if(strParam.IsEmpty())
		{
			/// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
			//strParam =PARAM_POLAR;
			//m_page.Info.System.DialogBar.Parameter$=PARAM_POLAR;
			SetStateFromPage();
			return TRUE;
			/// end POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
		}
		SetState(strParam);

		return TRUE;
	}
	
	BOOL CreateWindow(int nID, HWND hWnd)
	{
		InitMsgMap();
		int nRet = Dialog::Create(hWnd, DLG_AS_CHILD);
		HWND hWndThis = GetSafeHwnd();
		SetWindowLong(hWndThis, GWL_ID, nID);
		return nRet;
	}

	BOOL OnModifyAngularRange(Control ctrl)
	{
		LT_execute("getn \
				$Template.FunctionFrom x1 \
				$Template.FunctionTo x2 \
				$Template.FunctionIncrement x3 \
				$Template.FunctionAngRange;"
		);
		return TRUE;
	}
	BOOL SetOrientClockwise(Control ctrl)
	{
		LT_execute("layer -b pr 1");
			
		update_CW_CCW_buttons();//---- CPY 5/28/10 ORG-74-P1 CCW_CW_BUTTON_NOT_SHOWING_SWITCH_WHEN_CLICKED

		return TRUE;
	}
	BOOL SetOrientCounterClockwise(Control ctrl)
	{
		LT_execute("layer -b pr 0");
		update_CW_CCW_buttons();//---- CPY 5/28/10 ORG-74-P1 CCW_CW_BUTTON_NOT_SHOWING_SWITCH_WHEN_CLICKED
		return TRUE;
	}
	BOOL SetRadiusFromZero(Control ctrl)
	{
		LT_execute("layer -b polar 0");
		return TRUE;
	}
	BOOL SetRadiusFromYAxis(Control ctrl)
	{
		LT_execute("layer -b polar 1");
		return TRUE;
	}
	BOOL OnNewFunction(Control ctrl)
	{
		LT_execute("NewFunction");
		return TRUE;
	}

	BOOL OnRescale(Control ctrl)
	{
		LT_execute("layer -all ask;");
		return TRUE;
	}


	BOOL OnSwitchToPolar(Control ctrl)
	{
		string str;
		str.Format(SWITCH_LAYER,  m_bPolar ?  CART_FUN : POLAR_FUN);
		LT_execute(str);
		string strNewState(m_bPolar ? PARAM_FUNTION : PARAM_POLARFUNCTION);
		SetState(strNewState);
		return TRUE;
	}


	BOOL OnRename(Control ctrl)
	{
		LT_execute("%B=%C;\
			GetStr -s $Template.FunctionNewName %B;\
			set %C -n %B;\
			clr;");

		return TRUE;
	}

	void Show(int *pnCtrls, int nShow)
	{
		if(!pnCtrls)
			return;

		int nIndex = 0;
		while(pnCtrls[nIndex])
		{
			Control ctrl  = GetItem(pnCtrls[nIndex]);
			if(ctrl)
			{
				/// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
				if(nShow < 0)
				{
					ctrl.Enable = ENABLESHOW_BASE + nShow;
				}
				else
				/// end POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
				{
					ctrl.ShowWindow(nShow);
				}
			}
			nIndex ++;
		}
	}

	void SetSwitchName(LPCSTR lpcszName)
	{
		Control ctrlSwitc  =	GetItem(IDC_POLAR_SWITCH);
		if(ctrlSwitc)
			ctrlSwitc.Text =  lpcszName;
	}

	void OffsetButtons()
	{
		RECT rects[MAX_FUNCTION_CONTROLS];
		int n = 0;

		vector<uint> Wnds;
		while(nIDFunction[n])
		{
			Control ctrl  = GetItem(nIDFunction[n]);
			ctrl.GetWindowRect(&rects[n]);
			ScreenToClient(&rects[n]);
			Wnds.Add((uint)ctrl.GetSafeHwnd());
			n++;
		}

		int nOffset = m_nOffset;

		if(0 == m_nOffset)
		{
			m_nOffset = rects[0].left - 10;
			nOffset = -m_nOffset; 
		}
		else
		{
			m_nOffset = 0;
		}

		for(int ii = 0; ii < n; ii++)
		{
			rects[ii].left += nOffset;
			rects[ii].right += nOffset;
		}

		SizeMoveChildWindows(Wnds, rects);
		UpdateWindow(GetSafeHwnd());
	}
	void SetState(string &state)
	{
		if(state == PARAM_POLAR)
		{
			Show(nIDFunction, SW_HIDE);
			/// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
			m_bPolar 		= TRUE;
			m_bFuncKind		= FALSE;
			/// end POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
		}
		else if(state == PARAM_FUNTION)
		{
			Show(nIDPolar, SW_HIDE);
			Show(nIDRadius, SW_HIDE);
			m_bPolar = FALSE;
			m_bFuncKind		= TRUE;	/// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
			SetSwitchName(_L("Polar"));
			OffsetButtons();
			
		}
		else if(state == PARAM_POLARFUNCTION)
		{
			Show(nIDPolar, SW_SHOW);
			Show(nIDRadius, SW_HIDE);
			m_bPolar = TRUE;
			m_bFuncKind		= TRUE;	/// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
			SetSwitchName(_L("Cartesian"));
			if(m_nOffset)
				OffsetButtons();
		}
		UpdateRadio(); /// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
	}



private:

	BitmapRadioButton  m_brbCW, m_brbCCW;
	BOOL			   m_bPolar;
	int				   m_nOffset;
	BOOL			   m_bFuncKind;	/// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT


	GraphPage m_page;
	
};


